package com.bycom.versapro.Utils;

import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Serializables.Constant.appConfig;
import static com.bycom.versapro.Serializables.Constant.gson;
import static com.bycom.versapro.Utils.NetworkUtil.fetchAppInfo;
import static com.bycom.versapro.Utils.PrefUtil.getAppConfig;
import static com.bycom.versapro.Utils.PrefUtil.initializeSharedPref;
import static com.bycom.versapro.Utils.PrefUtil.isNight;

import android.app.Activity;
import android.app.Application;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;

import com.bycom.versapro.R;
import com.bycom.versapro.Serializables.AppConfig;
import com.bycom.versapro.Serializables.Constant;
import com.google.firebase.crashlytics.FirebaseCrashlytics;

import java.util.concurrent.CountDownLatch;


public class VersaProApp extends Application {


    Activity currentActivity = null;


    @Override
    public void onCreate() {
        super.onCreate();


        initializeSharedPref(this);


        if(isNight())
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES);
        else
            AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO);



        registerActivityLifecycleCallbacks(new ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {

            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {

            }

            @Override
            public void onActivityResumed(@NonNull Activity activity) {
                currentActivity = activity;
            }

            @Override
            public void onActivityPaused(@NonNull Activity activity) {

            }

            @Override
            public void onActivityStopped(@NonNull Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {

            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {

            }
        });



        ProcessLifecycleOwner.get().getLifecycle().addObserver(new DefaultLifecycleObserver() {
            @Override
            public void onPause(@NonNull LifecycleOwner owner) {
                DefaultLifecycleObserver.super.onPause(owner);
                if(adMobHelper!=null && appConfig != null){
                    adMobHelper.getAppOpenAdManager().loadAd(VersaProApp.this);
                }
            }

            @Override
            public void onResume(@NonNull LifecycleOwner owner) {
                DefaultLifecycleObserver.super.onResume(owner);
                if(adMobHelper!=null && appConfig != null && currentActivity != null){
                    adMobHelper.getAppOpenAdManager().showAdIfAvailable(currentActivity);
                }
            }
        });



    }



}
